#include "General.h"
#include "NoReloadSnipers.h"
#include "engine_weap.h"
#include "weaponmgr.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

#define STYLE_C4 0 // note that this list reflects the list in leveledit
#define STYLE_BEACON 6

int OldTime = 0;

void Set_Bullet_Count_All_Players()
{
	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();
		GameObject* obj = Get_GameObj(p->Get_Id());
		if (p->IsActive && obj)
		{	
			const char* CurrentWeapon = Get_Current_Weapon(obj);
			if (CurrentWeapon)
			{
				const WeaponDefinitionClass* Def = Get_Weapon_Definition(CurrentWeapon);

				if (Def->Style != STYLE_C4 && Def->Style != STYLE_BEACON) 
				{
					Set_Current_Bullets(obj, 4);
				}
			}
		}
	}	
}

void NoReloadSnipers::OnThink()
{
	int NewTime = (int)time(NULL);

	if ( (NewTime - OldTime) >= 1)
	{
		OldTime = NewTime;
//		Console_Output("One...\n");
		Set_Bullet_Count_All_Players();
	}
}

NoReloadSnipers::NoReloadSnipers()
{
	RegisterEvent(EVENT_THINK_HOOK,this);
}

NoReloadSnipers::~NoReloadSnipers()
{
	UnregisterEvent(EVENT_THINK_HOOK,this);
}

NoReloadSnipers noReloadSnipers;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &noReloadSnipers;
}
